# Example of how to derive R square for a linear regression

# where X = time and Y = error
time <- c(3,6,9,12,15,18)
error <- c(6.3,3.9,2.3,2.0,2.8,1.6)

N <- length(time)

# Derive the slope and the intercept with least squares
b1 <- cov(time,error)/var(time)
b0 <- mean(error) - b1*mean(time)

# Define the regression function
f <- function(x){b0 + b1*x}

# Find the predicted error values
error.predicted <- f(time)

# Find the residuals
residuals <- error - error.predicted

# Calculate R-squared
R2 <- 1 - var(residuals) / var(error)

R2.adj <- 1 - (1 - R2)*(N - 1)/(N - 2)

cat("R squared =", R2, "\n")
cat("adjusted R squared =", R2.adj, "\n")
